/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.sequence.mappers;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.misc.CharPredicate;
import icyllis.flexmark.util.sequence.mappers.CharMapper;

public class SpaceMapper {
    public static final CharMapper toNonBreakSpace = new ToNonBreakSpace();
    public static final CharMapper fromNonBreakSpace = new FromNonBreakSpace();

    public static boolean areEquivalent(char c1, char c2) {
        return c1 == c2 || c1 == ' ' && c2 == '\u00a0' || c2 == ' ' && c1 == '\u00a0';
    }

    @NotNull
    public static CharMapper toSpaces(@NotNull CharPredicate predicate) {
        return new FromPredicate(predicate);
    }

    private static class ToNonBreakSpace
    implements CharMapper {
        ToNonBreakSpace() {
        }

        @Override
        public char map(char c) {
            return c == ' ' ? (char)'\u00a0' : (char)c;
        }
    }

    private static class FromPredicate
    implements CharMapper {
        @NotNull
        final CharPredicate myPredicate;

        FromPredicate(@NotNull CharPredicate predicate) {
            this.myPredicate = predicate;
        }

        @Override
        public char map(char c) {
            return this.myPredicate.test(c) ? (char)' ' : (char)c;
        }
    }

    private static class FromNonBreakSpace
    implements CharMapper {
        FromNonBreakSpace() {
        }

        @Override
        public char map(char c) {
            return c == '\u00a0' ? (char)' ' : (char)c;
        }
    }
}

